// Xtimer_capture.c - adapted for LPC97x/98x

// This example is a demo of timer 4 on mode 1 (16-bit Timer with capture).
// An external falling edge on T4EX (P1.4) is needed to trigger a capture event. 
// If a capture occurs, the captured content will be recorded 
// and transmitted through UART interface. 

// last update: 2010 March 10
 
#include <REG98x.h> 				
#include <stdio.h>

// capture content and capture flag
unsigned char cap_datah, cap_datal, cap_flag;

unsigned char * str0 = "\nAn external 1 to 0 on T4EX (P1.4) is needed to trigger a capture \n";
unsigned char * str1 = "\nA capture occurs  ";
unsigned char * str2 = "RCAP4H:0x";
unsigned char * str3 = ", RCAP4L:0x";
unsigned char * str4 = "wrong data\n";

void timer4_init(void);
char putchar(char ch);
void putstring(char* str);
void capture_display(void);

// +++

void main(void)
{
	cap_datah = 0;
	cap_datal = 0;
	cap_flag  = 0;

	P0M1 = 0x00;		// bi-directional
	P0M2 = 0x00;
	P1M1 = 0x10;		// P1.4 input only, others bi-directional
	P1M2 = 0x00;
	P2M1 = 0x00;		// bi-directional
	P2M2 = 0x00;

   SCON   = 0x52;		// initialize UART 
   BRGR0  = 0xF0;    // 9600 baud, 8 bit, no parity, 1 stop bit 
   BRGR1  = 0x02;
   BRGCON = 0x03;

	putstring(str0);	//	display 

	timer4_init();		// set up timer4 in mode 1

 	while(1)
	{	
      // if a capture occurs => display the content and clear the flag
		if (cap_flag == 1)
		{
			capture_display();
			cap_flag = 0;
		} 
	}		
}

void timer4_init(void)
{
	  T4CON = 0x29;	// timer4 in mode 1
	  TH4   = 0;                         
	  TL4   = 0;

	  EXTIM =  1;
	  EA    =  1;
	  T4CON |= 0x04;	// start timer 4	     
}							

void XTimer_ISR(void) interrupt 11
{
   //check EXF4 flag
   if (TINTF & 0x10)
   {
    	cap_datah = RCAP4H;
    	cap_datal = RCAP4L;
    	cap_flag  = 1;
	}
   TINTF = 0;
}

char putchar (char ch)
{
  	TI = 0;
  	SBUF = ch;
  	while(TI == 0);
  	TI = 0;
  	return ch;
}

void putstring (char* str)
{
  	while (*str)
  	{
  		TI = 0;
  		SBUF = *str;
  		while(TI == 0);
		TI = 0;
		str++;
  	}
}		 

//display capture content
void  capture_display(void)
{
	unsigned char temp1,temp2;

	// cap_datah = temp1 * 16 + temp2
	temp1 = cap_datah / 16;
	temp2 = cap_datah % 16;
 	
	if((temp1>15) || (temp2>15))
	{
		putstring(str4);
		return;
	}

	temp1 += 0x30;
	temp2 += 0x30;
	if (temp1 > 0x39)
		temp1 += 0x7;
	if (temp2 > 0x39)
		temp2 += 0x7;
 
 	//display the content in RCAP4H register
	putstring(str1);
 	putstring(str2);
 	putchar(temp1);
	putchar(temp2);	    

	// cap_datal = temp1 * 16 + temp2
   temp1 = cap_datal / 16;
	temp2 = cap_datal % 16;
 	
	if((temp1 > 15) || (temp2 > 15))
	{
		putstring(str4);
		return;
	}

	temp1 += 0x30;
	temp2 += 0x30;
	if (temp1 > 0x39)
	 	temp1 += 0x7;
	if (temp2 > 0x39)
		temp2 += 0x7;

 	//display the content in RCAP4L register
 	putstring(str3);
	putchar(temp1);
	putchar(temp2);
} // end of capture_display